function BattleMenu()
{
	this.uOpen = false;
	this.dOpen = false;
	this.lOpen = false;
	this.rOpen = false;
	this.mainOpen = true;
	this.open = true;
}

BattleMenu.prototype.reset = function()
{
	this.uOpen = false;
	this.dOpen = false;
	this.lOpen = false;
	this.rOpen = false;
	this.mainOpen = true;
	this.open = true;
}

BattleMenu.prototype.execute = function(character)
{
	this.open = true;
	character.situation = "Battle-input";
	character.aDirection = "south";
	// Creates menu for using items
	var itemMenu = new Menu();
	itemMenu.importArray(Game.items);
	// Creates menu for using specials
	var specMenu = new Menu();
	specMenu.doWhile = SpecialInfo;
	specMenu.importArray(character.specials);
	// Creates menu for using misc. commands
	var miscMenu = new Menu();
	miscMenu.addItem("Defend");
	miscMenu.addItem("Run Away!");
	// Creates menu for attacking
	var atkMenu = new Menu();
	atkMenu.importArray(Game.battle.enemy);
	atkMenu.drawAny = false;
	atkMenu.doWhile = EnemyInfo;
	var s = undefined;
	while (this.open)
	{
		Game.battle.draw();
		if (this.uOpen)
		{
			images.bCommandExpand.blit(character.x - 7, character.y - 18);
			font.bFont.drawText(character.x + 2, character.y - 13, "ITEM");
			//s = itemMenu.execute(187, 160, 122, 5);
		}
		else
		{
			images.bCommandSmall.blit(character.x, character.y - 18);
		}
		if (this.dOpen)
		{
			images.bCommandExpand.blit(character.x - 7, character.y + 18);
			font.bFont.drawText(character.x + 3, character.y + 23, "ETC.");
			//s = miscMenu.execute(187, 197, 122, 2);
		}
		else
			images.bCommandSmall.blit(character.x, character.y + 18);
		if (this.lOpen)
		{
			images.bCommandExpand.blit(character.x - 32, character.y);
			font.bFont.drawText(character.x - 28, character.y + 5, "SPECIAL");
			//s = specMenu.execute(187, 160, 122, 5);
		}
		else
			images.bCommandSmall.blit(character.x - 18, character.y);
		if (this.rOpen)
		{
			images.bCommandExpand.blit(character.x + 18, character.y);
			font.bFont.drawText(character.x + 22, character.y + 5, "ATTACK");
			s = atkMenu.execute(10, 10, 10, Game.battle.enemy.length);
		}
		else
			images.bCommandSmall.blit(character.x + 18, character.y);
		// Put stuff to draw windows and such
		FlipScreen();
		if (KeyPressed())
		{
			if (this.mainOpen)
			{
				if (IsKeyPressed(KEY_UP))
				{
					this.uOpen = true;
					this.mainOpen = false;
					PressKey();
				}
				if (IsKeyPressed(KEY_DOWN))
				{
					this.dOpen = true;
					this.mainOpen = false;
					PressKey();
				}
				if (IsKeyPressed(KEY_LEFT))
				{
					this.lOpen = true;
					this.mainOpen = false;
					PressKey();
				}
				if (IsKeyPressed(KEY_RIGHT))
				{
					this.rOpen = true;
					this.mainOpen = false;
					PressKey();
				}
			}
			else
			{
				if (IsKeyPressed(KEY_SPACE))
				{
					this.mainOpen = true;
					this.uOpen = false;
					this.dOpen = false;
					this.lOpen = false;
					this.rOpen = false;
					PressKey("cancel");
				}
			}
		}
		if (s != undefined)
		{
			if (this.uOpen)
			{
			}
			else if (this.dOpen)
			{
			}
			else if (this.lOpen)
			{
			}
			else if (this.rOpen)
			{
				Attack(character, Game.battle.enemy[s]);
			}
			this.open = false;
		}
	}
}

function EnemyInfo(selection)
{
	var enemy = Game.battle.enemy[selection];
	var character = Game.battle.character;
	Line(character.x, character.y, enemy.x, enemy.y, colors.yellowA);
	window.drawWindow(187, 197, 122, 32);
	font.drawText(189, 201, enemy.name);
	if (character.equipment[0].name == "")
	{
		font.drawText(189, 213, "Unarmed");
	}
	else
		font.drawText(189, 213, character.equipment[0].name);
}

function SpecialInfo(selection)
{
	var special = Game.battle.character.specials[selection];
	var character = Game.battle.character;
	window.drawWindow(187, 145, 102, 10);
	images.star.blit(189, 147);
	font.drawText(199, 147, "#");
	if (special != undefined)
	{
		font.drawText(206, 147, special.mp, "left", colors.orange);
	}
	font.drawText(262, 147, character.mp, "right", colors.orange);
	font.drawText(262, 147, "/");
	font.drawText(267, 147, character.mpmax, "left", colors.orange);
}

function getTurn()
{
	var turn = new Object();
	turn.speed = -1;
	turn.act = false;
	for (var i = 0; i < Game.pSize; i ++)
	{
		if (!Game.party[i].act)
		{
			if (Game.party[i].speed > turn.speed)
			{
				turn = Game.party[i];
			}
		}
	}
	for (var i = 0; i < Game.battle.enemy.length; i ++)
	{
		if (Game.battle.enemy[i].hp > 0)
		{
			if (!Game.battle.enemy[i].act)
			{
				if (Game.battle.enemy[i].speed > turn.speed)
				{
					turn = Game.battle.enemy[i];
				}
			}
		}
	}
	if (turn.speed == -1)
	{
		return false;
	}
	else
		return turn;
}

function Attack(person, target)
{
	var pMoving = true;
	var l = target.x - person.x;
	var h = target.y - person.y;
	var pAnimate = false;
	var eAnimate = false;
	var dAnimate = false;
	var enAnimate = false
	var pMoveBack = false;
	var time = 0;
	var done = false;
	while (!done)
	{
		Game.battle.draw();
		if (pMoving)
		{
			if (time < 10)
			{
				person.x += l / 10;
				person.y += h / 10;
				time ++;
			}
			else
			{
				time = 0;
				pMoving = false;
				pAnimate = true;
			}
		}
		if (pAnimate)
		{
			person.situation = "Attacking";
			person.aDirection = "Battle-attack";
			if (person.aFrame >= person.sprite.directions[StrToDir("Battle-attack", person.sprite)].frames.length - 1)
			{
				person.aFreeze = true;
				pAnimate = false;
				eAnimate = true;
			}
		}
		if (eAnimate)
		{
			eAnimate = false;
			enAnimate = true;
		}
		if (enAnimate)
		{
			target.situation = "Hurting";
			target.aDirection = "Battle-hurt";
			if (target.aFrame >= target.sprite.directions[StrToDir("Battle-hurt", target.sprite)].frames.length - 1)
			{
				target.aFreeze = true;
				enAnimate = false;
				dAnimate = true;
			}
		}
		if (dAnimate)
		{
			var damage = person.attack(target);
			if (time < 20)
			{
				font.drawText(target.x, target.y + target.sprite.images[0].height - 8, damage);
				time ++;
			}
			else
			{
				target.hp -= Damage(target, damage);
				if (target.hp == 0)
				{
					target.die();
				}
				time = 0;
				dAnimate = false;
				pMoveBack = true;
			}
		}
		if (pMoveBack)
		{
			person.situation = "Normal";
			person.aFreeze = false;
			target.situation = "Normal";
			target.aFreeze = false;
			if (time < 10)
			{
				person.x -= l / 10;
				person.y -= h / 10;
				time ++;
			}
			else
			{
				time = 0;
				pMoveBack = false;
				done = true;
			}
		}
		FlipScreen();
	}
}

function UseItem(person, item)
{

}

function UseSpecial(person, target, special)
{

}

function Unavailable(person)
{
	if (person.hp == 0)
	{
		return true;
	}
	else
		return false;
}